<?php
// Simple test to verify captcha system
require_once 'captcha_system.php';

echo "Testing SimpleCaptcha class...\n";

try {
    $captcha = new SimpleCaptcha();
    $result = $captcha->generateCaptcha();
    
    echo "✓ Captcha generation successful\n";
    echo "✓ Token generated: " . substr($result['token'], 0, 10) . "...\n";
    echo "✓ HTML length: " . strlen($result['html']) . " characters\n";
    
    // Test verification status
    $verified = SimpleCaptcha::isCaptchaVerified();
    echo "✓ Verification status: " . ($verified ? 'true' : 'false') . "\n";
    
    echo "\nCaptcha system is working correctly!\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}
?>