<?php
session_start();

class HCaptchaSystem {
    private $site_key = 'd054f9be-9660-49c4-b45e-6762444a3062';
    private $secret_key = 'ES_e4e7120111ca484eb67b6ce169f5ca8c';
    
    public function generateCaptchaHTML() {
        $html = '<div id="hcaptcha-container" class="captcha-container">';
        $html .= '<div class="captcha-header">';
        $html .= '<div class="captcha-icon">🔒</div>';
        $html .= '<h3>Security Check</h3>';
        $html .= '<p>Please complete the verification below to continue</p>';
        $html .= '</div>';
        
        $html .= '<div class="hcaptcha-wrapper">';
        $html .= '<div class="h-captcha" data-sitekey="' . $this->site_key . '" data-callback="onHCaptchaSuccess"></div>';
        $html .= '</div>';
        
        $html .= '<button type="button" id="continue-btn" class="captcha-verify-btn" disabled style="background:#ccc;cursor:not-allowed;opacity:0.6;" onclick="proceedToSite()">Continue</button>';
        
        $html .= '</div>';
        
        return $html;
    }
    
    public function verifyHCaptcha($token) {
        if (empty($token)) {
            return ['success' => false, 'error' => 'No captcha token provided'];
        }
        
        $data = [
            'secret' => $this->secret_key,
            'response' => $token,
            'remoteip' => $this->getRealIP()
        ];
        
        $verify_url = 'https://hcaptcha.com/siteverify';
        
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $verify_url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($curl);
        $http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        curl_close($curl);
        
        if ($response === false || $http_code !== 200) {
            return ['success' => false, 'error' => 'Failed to verify captcha'];
        }
        
        $result = json_decode($response, true);
        
        if ($result && $result['success']) {
            $_SESSION['hcaptcha_verified'] = true;
            $_SESSION['hcaptcha_timestamp'] = time();
            return ['success' => true];
        } else {
            $error_codes = isset($result['error-codes']) ? implode(', ', $result['error-codes']) : 'Unknown error';
            return ['success' => false, 'error' => 'Captcha verification failed: ' . $error_codes];
        }
    }
    
    private function getRealIP() {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            return $_SERVER['REMOTE_ADDR'];
        }
    }
    
    public static function isCaptchaVerified() {
        return isset($_SESSION['hcaptcha_verified']) && 
               $_SESSION['hcaptcha_verified'] === true &&
               isset($_SESSION['hcaptcha_timestamp']) &&
               (time() - $_SESSION['hcaptcha_timestamp']) < 3600; // Valid for 1 hour
    }
}
?>